CKEDITOR.dom.range.prototype.wrapSelectionWith = function(start, end)
{
	var startNode, endNode;
	var clone;

	// make sure we are including bold/italic/underline/etc tags
	this.enlarge(CKEDITOR.ENLARGE_ELEMENT);

	startNode = CKEDITOR.dom.element.createFromHtml(start, this.document);
	endNode = CKEDITOR.dom.element.createFromHtml(end, this.document);

	// insert closing tag
	clone = this.clone();
	clone.collapse();
	clone.insertNode(endNode);
	if (this.collapsed)
	{
		this.moveToPosition(endNode, CKEDITOR.POSITION_BEFORE_START);
	}

	// insert start tag
	clone = this.clone();
	clone.collapse(true);
	clone.insertNode(startNode);
	if (this.collapsed)
	{
		this.moveToPosition( startNode, CKEDITOR.POSITION_AFTER_END );
	}
	
	// reselect ranges
	if (!this.collapsed)
	{
		this.setEndBefore(endNode);
		this.setStartAfter(startNode);
	}
}

CKEDITOR.editor.prototype.getSelectedText = function()
{
	if (CKEDITOR.env.ie)
	{
		return this.getSelection().document.$.selection.createRange().text;
	}
	else
	{
		return this.getSelection().getNative();
	}	
}

CKEDITOR.editor.prototype.wrapSelectionWith = function(start, end)
{
	if (this.mode == "wysiwyg")
	{
		if (CKEDITOR.env.ie)
		{
			this.focus();
		}
		var ranges = this.getSelection().getRanges();
		for (var i = 0; i < ranges.length; i++)
		{
			ranges[i].wrapSelectionWith(start, end);
		}
		this.getSelection().selectRanges(ranges);
	}
	else if (this.mode == "enhancedsource")
	{
		this.esWrapAroundSelection(start, end);
	}
}

CKEDITOR.plugins.add('hidetags',
{
	requires : [ 'button' ],
	
	init : function( editor )
	{
		var phrase = editor.config.vbulletin.phrase;

		// All buttons use the same code to register. So, to avoid
		// duplications, let's use this tool function.
		var hidetagCommand = function(buttonName, buttonLabel, tagName, option, image)
		{
			editor.addCommand(buttonName, 
			{
			    modes : { enhancedsource:1, wysiwyg:1 },

				exec: function(editor)
				{
					if (option == '1')
					{
						var optionString = prompt(editor.config.vbulletin.phrase.hide_post_button.replace(/\%1\$s/, tagName));
						if (typeof optionString == 'string' && optionString.length > 0)
						{
							editor.wrapSelectionWith('[' + tagName + '=' + optionString + ']', '[/' + tagName + ']');
						}
						else
						{
							editor.wrapSelectionWith('[' + tagName + ']', '[/' + tagName + ']');
						}
					}
					else
					{
						editor.wrapSelectionWith('[' + tagName + ']', '[/' + tagName + ']');
					}
				}
			});
			
			var buttonDefinition = {label : buttonLabel, command : buttonName};
			if (image)
			{
				buttonDefinition.icon = image;
			}

			editor.ui.addButton(buttonName, buttonDefinition);
		};
		
// Full sample plugin, which does not only register a dialog window but also adds an item to the context menu.
// To open the dialog window, choose "Open dialog" in the context menu.

	var Showtogroups = function(buttonName, tagName, image)
	{
	    editor.ui.addButton(buttonName,
		{
			// label: adds a hover text to the button. This uses the vBulletin
			// phrase "celButtonDemo" which you will have to add to your phrases
			// and to pass to CKE in a plugin
			label : phrase.wrap_x_tags.replace(/\%1\$s/, tagName),
			// command: the command that will be executed. It's defined later
			// in this file
			command : 'groupselection' + tagName,
			// icon: The path to the icon file you want to use for your button.
			// Here we use buttonimage.png in the buttons directory defined for
			// the current style (default: /images/editor)
            icon: BBURL + '/' + IMGDIR_BUTTON + '/' + image
		});


        var command = editor.addCommand('groupselection' + tagName, new CKEDITOR.dialogCommand('groupselection' + tagName));
		command.modes = { wysiwyg:1, enhancedsource:1 }; 
		
		CKEDITOR.dialog.add( 'groupselection' + tagName, function( editor )
		{

			// CKEDITOR.dialog.definition
			var dialogDefinition =
			{   
				title : 'Select Usergroups',
				minWidth : 300,
				minHeight : 130,
				contents : [
					{
						id : 'vfc_groupsselect' + tagName,
						label : 'vFCoders - Hide Hack [SHOWTOGROUPS tag]',
						title : 'Select Usergroups',
						expand : false,
						padding : 10,
						elements :
						[

							{
								type : 'select',
								id : 'usergroups',
								label: phrase.vfc_hide_hack_select_usergroup.replace(/\%1\$s/, tagName) + '<br><br>',
                                items : editor.config.vbulletin.vfc_hide_hack_uglist_editor,
	                            'default' : '',
								multiple: true
								
								
							}
						]
					}
				],
				buttons : [ CKEDITOR.dialog.okButton, CKEDITOR.dialog.cancelButton ],
				onOk : function() {
					// "this" is now a CKEDITOR.dialog object.
					// Accessing dialog elements:

			    var usergroups = this.getContentElement( 'vfc_groupsselect' + tagName, 'usergroups' );
				var ob = usergroups.getInputElement().$;
                var selected = new Array();
                for (var i = 0; i < ob.options.length; i++) 
				{
                   if (ob.options[ i ].selected) {
                             selected.push(ob.options[ i ].value);
                                                 }
                }
				
				if (selected.length != 0)
						{
					       editor.wrapSelectionWith('[' + tagName + '=' + selected + ']', '[/' + tagName + ']');
						}
						else
						{
							editor.wrapSelectionWith('[' + tagName + ']', '[/' + tagName + ']');
						}

				                  }
			};

			return dialogDefinition;
		} );
    };


		var phrase = editor.config.vbulletin.phrase;

		if (editor.config.vbulletin.vfc_hide_hack_hide_option != 2)
		{
           if (editor.config.vbulletin.vfc_hide_hack_hide_option == 1)
		  {
		    var isoptionon = '1';
		  }		
		hidetagCommand('Hide', phrase.wrap_x_tags.replace(/\%1\$s/, 'HIDE'), 'HIDE', isoptionon, BBURL + '/' + IMGDIR_BUTTON + '/hide.gif');
		}
		else
		{
		Showtogroups('Hide', 'HIDE', 'hide.gif');
		}
		hidetagCommand('HReply', phrase.wrap_x_tags.replace(/\%1\$s/, 'HIDE-REPLY'), 'HIDE-REPLY', '0', BBURL + '/' + IMGDIR_BUTTON + '/hreply.gif');
        hidetagCommand('HReplyThanks', phrase.wrap_x_tags.replace(/\%1\$s/, 'HIDE-REPLY-THANKS'), 'HIDE-REPLY-THANKS', '0', BBURL + '/' + IMGDIR_BUTTON + '/hreplythanks.gif');
        hidetagCommand('Hthanks', phrase.wrap_x_tags.replace(/\%1\$s/, 'HIDE-THANKS'), 'HIDE-THANKS', '0', BBURL + '/' + IMGDIR_BUTTON + '/hthanks.gif');
		hidetagCommand('HPosts', phrase.wrap_x_tags.replace(/\%1\$s/, 'HIDE-POSTS'), 'HIDE-POSTS', '1', BBURL + '/' + IMGDIR_BUTTON + '/hposts.gif');
        Showtogroups('Showtogroups', 'SHOWTOGROUPS', 'showtogroups.gif');
	}

});


